% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard_fun.R
\encoding{UTF-8}
\name{hazard_fun}
\alias{hazard_fun}
\title{Hazard functions in \code{maxlogL} framework}
\usage{
hazard_fun(dist, support)
}
\arguments{
\item{dist}{a length-one character vector with the name of density/mass function
of interest.}

\item{support}{a list with the following entries:
\itemize{
\item \code{interval}: a two dimensional atomic vector indicating the
set of possible values of a random variable having the
distribution specified in \code{y_dist}.
\item \code{type}: character indicating if distribution has a
\code{discrete} or a \code{continous} random variable.
}}
}
\value{
A function with the folling input arguments:
\item{x}{vector of (non-negative) quantiles.}
\item{...}{Arguments of the probability density/mass function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes the name of a probability density/mass function as an
argument and creates a hazard function.
}
\examples{
library(EstimationTools)

#--------------------------------------------------------------------------------
# Example 1: Hazard function of Weibull distribution.
hweibull1 <- hazard_fun('dweibull', list(interval=c(0, Inf), type='continuous'))
hweibull2 <- function(x){
  ans <- dweibull(x, shape = 2, scale = 1)/
    pweibull(x, shape = 2, scale = 1, lower.tail = FALSE)
  ans
}
hweibull1(0.2, shape = 2, scale = 1)
hweibull2(0.2)


#--------------------------------------------------------------------------------

}
\seealso{
Other maxlogL: 
\code{\link{maxlogLreg}()},
\code{\link{maxlogL}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{maxlogL}
