% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_report.R
\name{getTemplate}
\alias{getTemplate}
\title{Get epidemiological report (empty) template}
\usage{
getTemplate(output_path)
}
\arguments{
\item{output_path}{character string, the full path where to create the 'Word' output.
Defaut location will be the current working directory (default \code{getwd()})}
}
\value{
A 'Word' document
}
\description{
Function to export the generic 'Microsoft Word' empty template (included in
the \code{'EpiReport'} package) used to produce the
epidemiological report similar to the ECDC Annual Epidemiological Report (AER).
The modified version of the template can then be used to produce the final
epidemiological report using \code{getAER(template = 'NewTemplate.docx', ...)} \cr
(see the package vignette "The Epidemiological Report Package" with
\code{browseVignettes("EpiReport")})  \cr
(see ECDC annual epidemilogical reports \url{https://www.ecdc.europa.eu/en/annual-epidemiological-reports})
}
\examples{

\dontrun{
# --- Export the template in the default folder: working directory
getTemplate()

# --- Or specify the full path
getTemplate(output_path = getwd())
}


}
\seealso{
\code{\link{getAER}}
}
