% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_infections.R
\name{simulate_infections}
\alias{simulate_infections}
\title{Simulate infections using the renewal equation}
\usage{
simulate_infections(
  estimates,
  R,
  initial_infections,
  day_of_week_effect = NULL,
  generation_time = generation_time_opts(),
  delays = delay_opts(),
  truncation = trunc_opts(),
  obs = obs_opts(),
  CrIs = c(0.2, 0.5, 0.9),
  backend = "rstan",
  seeding_time = NULL,
  pop = 0,
  ...
)
}
\arguments{
\item{estimates}{deprecated; use \code{\link[=forecast_infections]{forecast_infections()}} instead}

\item{R}{a data frame of reproduction numbers (column \code{R}) by date (column
\code{date}). Column \code{R} must be numeric and \code{date} must be in date format. If
not all days between the first and last day in the \code{date} are present,
it will be assumed that R stays the same until the next given date.}

\item{initial_infections}{numeric; the initial number of infections (i.e.
before \code{R} applies). Note that results returned start the day after, i.e.
the initial number of infections is not reported again. See also
\code{seeding_time}}

\item{day_of_week_effect}{either \code{NULL} (no day of the week effect) or a
numerical vector of length specified in \code{\link[=obs_opts]{obs_opts()}} as \code{week_length}
(default: 7) if \code{week_effect} is set to TRUE. Each element of the vector
gives the weight given to reporting on this day (normalised to 1).
The default is \code{NULL}.}

\item{generation_time}{A call to \code{\link[=gt_opts]{gt_opts()}} (or its alias
\code{\link[=generation_time_opts]{generation_time_opts()}}) defining the generation time distribution used.
For backwards compatibility a list of summary parameters can also be passed.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{truncation}{A call to \code{\link[=trunc_opts]{trunc_opts()}} defining the truncation of
the observed data. Defaults to \code{\link[=trunc_opts]{trunc_opts()}}, i.e. no truncation.  See the
\code{\link[=estimate_truncation]{estimate_truncation()}} help file for an approach to estimating this from
data where the \code{dist} list element returned by \code{\link[=estimate_truncation]{estimate_truncation()}} is
used as the \code{truncation} argument here, thereby propagating the uncertainty
in the estimate.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{backend}{Character string indicating the backend to use for fitting
stan models. Supported arguments are "rstan" (default) or "cmdstanr".}

\item{seeding_time}{Integer; the number of days before the first time point
of \code{R}; default is \code{NULL}, in which case it is set to the maximum of the
generation time. The minimum is 1 , i.e. the first reproduction number
given applies on the day after the index cases given by
\code{initial_infections}. If the generation time is longer than 1 day on
average, a seeding time of 1 will always lead to an initial decline (as
there are no infections before the initial ones). Instead, if this is
greater than 1, an initial part of the epidemic (before the first value of
R given) of \code{seeding_time} days is assumed to have followed exponential
growth roughly in line with the growth rate implied by the first value of
R.}

\item{pop}{Integer, defaults to 0. Susceptible population initially present.
Used to adjust Rt estimates when otherwise fixed based on the proportion of
the population that is susceptible. When set to 0 no population adjustment
is done.}

\item{...}{deprecated; only included for backward compatibility}
}
\value{
A data.table of simulated infections (variable \code{infections}) and
reported cases (variable \code{reported_cases}) by date.
}
\description{
Simulations are done from given initial infections and, potentially
time-varying, reproduction numbers. Delays and parameters of the observation
model can be specified using the same options as in \code{\link[=estimate_infections]{estimate_infections()}}.
}
\details{
In order to simulate, all parameters that are specified such as the mean and
standard deviation of delays or observation scaling, must be fixed.
Uncertain parameters are not allowed.
}
\examples{
\donttest{
R <- data.frame(
  date = seq.Date(as.Date("2023-01-01"), length.out = 14, by = "day"),
  R = c(rep(1.2, 7), rep(0.8, 7))
)
sim <- simulate_infections(
  R = R,
  initial_infections = 100,
  generation_time = generation_time_opts(
    fix_parameters(example_generation_time)
  ),
  delays = delay_opts(fix_parameters(example_reporting_delay)),
  obs = obs_opts(family = "poisson")
)
}
}
