% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{mean.dist_spec}
\alias{mean.dist_spec}
\title{Returns the mean of one or more delay distribution}
\usage{
\method{mean}{dist_spec}(x, ..., ignore_uncertainty = FALSE)
}
\arguments{
\item{x}{The \verb{<dist_spec>} to use}

\item{...}{Not used}

\item{ignore_uncertainty}{Logical; whether to ignore any uncertainty in
parameters. If set to FALSE (the default) then the mean of any uncertain
parameters will be returned as NA.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This works out the mean of all the (parametric / nonparametric) delay
distributions combined in the passed \code{\link[=dist_spec]{dist_spec()}} (ignoring any uncertainty
in parameters)
}
\examples{
# A fixed lognormal distribution with mean 5 and sd 1.
dist1 <- LogNormal(mean = 5, sd = 1, max = 20)
mean(dist1)

# An uncertain gamma distribution with mean 3 and sd 2
dist2 <- Gamma(
 mean = Normal(3, 0.5), sd = Normal(2, 0.5), max = 20
)
mean(dist2)

# The mean of the sum of two distributions
mean(dist1 + dist2)
}
