% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.record.R
\name{record_raw_object}
\alias{record_raw_object}
\title{Record an Arbitrary Object During a Simulation}
\usage{
record_raw_object(dat, at, label, object)
}
\arguments{
\item{dat}{a Master list object of network models}

\item{at}{the time where the recording happens}

\item{label}{the name to give to the recorded object}

\item{object}{the object to be recorded}
}
\value{
The Master list object
}
\description{
This function records any object during a simulation to allow it's
inspection afterward. The records are stored in \code{dat[["raw.records"]]}
during the simulation and in the \code{netsim} object under the
\code{raw.records} sublists.
}
\details{
See the "Time Varying Attributes" vignette
}
\examples{
\dontrun{

dat <- record_raw_object(dat, at, "a.df", data.frame(x = 2:200))
dat <- record_raw_object(dat, at, "a.message", "I recorded something")

}

}
