% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendo.R, R/get.R
\name{is.transmat}
\alias{is.transmat}
\alias{transmat}
\alias{get_transmat}
\title{Extract Transmissions Matrix from Network Epidemic Model}
\usage{
is.transmat(x)

get_transmat(x, sim = 1)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{\link{netsim}}.}

\item{sim}{Simulation number of extracted network.}
}
\value{
A data frame with the following columns
\itemize{
 \item \strong{at:} the time step at which the transmission occurred.
 \item \strong{sus:} the ID number of the susceptible (newly infected) node.
 \item \strong{inf:} the ID number of the infecting node.
 \item \strong{infDur:} the duration of the infecting node's disease at the
       time of the transmission.
 \item \strong{transProb:} the probability of transmission per act.
 \item \strong{actRate:} the rate of acts per unit time.
 \item \strong{finalProb:} the final transmission probability for the
       transmission event.
}
}
\description{
Extracts the matrix of transmission data for each transmission
             event that occured within a network epidemic model.
}
\examples{
## Simulate SI epidemic on two-group Bernoulli random graph
nw <- network_initialize(n = 100)
nw <- set_vertex_attribute(nw, "group", rep(1:2, each = 50))
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)
param <- param.net(inf.prob = 0.3, inf.prob.g2 = 0.15)
init <- init.net(i.num = 10, i.num.g2 = 10)
control <- control.net(type = "SI", nsteps = 10, nsims = 3, verbose = FALSE)
mod <- netsim(est, param, init, control)

## Extract the transmission matrix from simulation 2
get_transmat(mod, sim = 2)

}
\keyword{extract}
