% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areaSouce.R
\name{areaSource}
\alias{areaSource}
\title{Distribution of emissions by area}
\format{
a raster
}
\source{
Data avaliable \url{https://www.ospo.noaa.gov/Operations/DMSP/index.html}
}
\usage{
areaSource(s, r, grid = NA, name = "", as_frac = F, verbose = T)
}
\arguments{
\item{s}{input shape object}

\item{r}{input raster object}

\item{grid}{grid with the output format}

\item{name}{area name}

\item{as_frac}{return a fraction instead of a raster}

\item{verbose}{display additional data}
}
\description{
Calculate the spatial distribution by a raster kasked by shape/model grid information.
}
\details{
About the DMSP and example data \url{https://en.wikipedia.org/wiki/Defense_Meteorological_Satellite_Program}
}
\examples{
shape  <- raster::shapefile(paste(system.file("extdata", package = "EmissV"),
                            "/BR.shp",sep=""),verbose = FALSE)
shape  <- shape[22,1] # subset for Sao Paulo - BR
raster <- raster::raster(paste(system.file("extdata", package = "EmissV"),
                         "/dmsp.tiff",sep=""))
grid   <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d02",sep=""))
SP     <- areaSource(shape,raster,grid,name = "SPMA")
\donttest{
sp::spplot(SP,scales = list(draw=TRUE),ylab="Lat",xlab="Lon",
           main=list(label="Spatial Distribution by Lights for Sao Paulo - Brazil"),
           col.regions = c("#031638","#001E48","#002756","#003062",
                           "#003A6E","#004579","#005084","#005C8E",
                           "#006897","#0074A1","#0081AA","#008FB3",
                           "#009EBD","#00AFC8","#00C2D6","#00E3F0"))
}

}
