% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ExpressionGradient}
\alias{ExpressionGradient}
\title{The ggplot2 scale gradient from ExpressionPalette.}
\usage{
ExpressionGradient(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:scale_color_gradientn]{ggplot2::scale_color_gradientn()}}}
}
\description{
The ggplot2 scale gradient from ExpressionPalette.
}
\examples{
library(EmbedSOM)
library(ggplot2)

# simulate a simple dataset
e <- cbind(rnorm(10000),rnorm(10000))

data <- data.frame(Val=log(1+e[,1]^2+e[,2]^2))
PlotGG(e, data=data) +
  geom_point(aes_string(color="Val"), alpha=.5) +
  ExpressionGradient(guide=FALSE)
}
