% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_treeline.R
\name{sample_treeline}
\alias{sample_treeline}
\title{Compute the local treeline}
\usage{
sample_treeline(df, lonLength, latLength, stepSize = 0.0025)
}
\arguments{
\item{df}{Data frame generated by the function \code{classify_above_treeline} and therefore containing: longitude,
latitude (WGS 84), growing season temperature, growing season length, and a boolean. Longitude and latitude
must be of the data type "numeric" and finite. For the boolean \code{TRUE}, \code{FALSE} and
\code{NA} is allowed and nothing else.}

\item{lonLength}{Vector containing the length of the longitudinal sequence. One value, data type "numeric".
This information is part of the \code{generate_grid} output. One value, data type "numeric" and finite.}

\item{latLength}{Vector containing the length of the latitudinal sequence. One value, data type "numeric".
This information is part of the \code{generate_grid} output. One value, data type "numeric" and finite.}

\item{stepSize}{Step size for the square sampling (in degree). One value, data type "numeric". This \code{stepSize}
must be identical with the \code{stepSize} used in the function \code{generate_grid}. It is used to calculate the center
between two grid points. One value, data type "numeric" and finite.}
}
\value{
A data frame containing line-shaped polygons. Each row containing: a identifier, a start latitude and longitude, a end latitude and longitude.
}
\description{
Calculate horizontal and vertical lines between two different classified points from the \code{df} input.
If used in the context of the treeline: when a point above the treeline (\code{TRUE}) and a point below the treeline
(\code{FALSE}) lie next to each other, the start and the end of the line is calculated and stored. This data point
collection represents the local treeline. It is highly recommended to use this function only in combination with
\code{generate_grid} and \code{classify_above_treeline}. The coordinates in the \code{df} can only be meaningfully processed
if they have the same order and structure as results from \code{generate_grid}.
}
\examples{
#Recommended usage
temp <- generate_grid(lon = 8.728898, lat = 46.93756, squareSize = 10, stepSize = 0.0025)

gstURL <- paste0("https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/",
                 "climatologies/1981-2010/bio/CHELSA_gst_1981-2010_V.2.1.tif")
gslURL <- paste0("https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/",
                 "climatologies/1981-2010/bio/CHELSA_gsl_1981-2010_V.2.1.tif")
\donttest{
gst <- terra::rast(gstURL, vsi = TRUE)
gsl <- terra::rast(gslURL, vsi = TRUE)

temp$df <- classify_above_treeline(coords = temp$df, gstRaster = gst, gslRaster = gsl)

treeline <- sample_treeline(df = temp$df, lonLength = temp$lonLength,
                            latLength = temp$latLength, stepSize = 0.0025)
}
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
