% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.sdf.R
\name{rename.sdf}
\alias{rename.sdf}
\title{Modify Variable Names}
\usage{
rename.sdf(x, oldnames, newnames, avoid_duplicated = TRUE)
}
\arguments{
\item{x}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
or an \code{edsurvey.data.frame.list}}

\item{oldnames}{a character vector of old variable names}

\item{newnames}{a character vector of new variable names to replace the
corresponding old names}

\item{avoid_duplicated}{a logical value to indicate whether to avoid renaming the
variable if the corresponding new name already exists in the data. 
Defaults to \code{TRUE}.}
}
\value{
an object of the same class as \code{x} with new variable names
}
\description{
Renames variables in an \code{edsurvey.data.frame}, 
a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
This function often is used when users want to conduct a gap analysis across
 years but variable names differ across two years of data.
}
\details{
All variable names are coerced to lowercase to comply with
         the \code{EdSurvey} standard.
}
\examples{
\dontrun{
usaG4.15 <- readTIMSS("~/TIMSS/2015", "usa", 4)
usaG4.15.renamed <- rename.sdf(usaG4.15,
                               c("itsex", "mmat"),
                               c("gender", "math_overall"))
lm1 <- lm.sdf(math_overall ~ gender, data = usaG4.15.renamed)
summary(lm1)
}
}
\seealso{
\code{\link{gap}}
}
\author{
Trang Nguyen
}
