% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{genepop2ecogen}
\alias{genepop2ecogen}
\title{Importing a Genepop file}
\usage{
genepop2ecogen(genefile = NULL)
}
\arguments{
\item{genefile}{Genepop file.}
}
\value{
A list with the objects G (genetic matrix) and S (structures matrix).
}
\description{
This function converts a Genepop file into an object 
with a genetic matrix (G) and a structures matrix (S).
}
\examples{
\dontrun{
# ingpop, file with Genepop format in the folder "/extdata" of the package

ecopath <- paste(path.package("EcoGenetics"), "/extdata/ingpop", sep = "")
ingpop <- genepop2ecogen(ecopath)
ingpop
}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}, adapting code
written by Emiel van Loon and Scott Davis
}

