% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.variogram.R
\name{eco.variogram}
\alias{eco.variogram}
\title{Variogram for variables of an ecogen object.}
\usage{
eco.variogram(eco, var, ...)
}
\arguments{
\item{eco}{An ecogen object.}

\item{var}{Variable to analyze (see description).}

\item{...}{Further arguments passed to \code{\link[gstat]{variogram}}.}
}
\description{
This program calls  \code{\link[gstat]{variogram}}
and plots a variogram of a selected variable contained in an ecogen object.

For example, for selecting the variable P2 of the data frame P,
it should be written eco$P$P2, and so on.
}
\examples{
\dontrun{

data(eco.test)
variog<-eco.variogram(eco, eco$P$P2, cutoff = 3000)
variog

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

