% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior_sampling.R
\name{prior_ensemble_model}
\alias{prior_ensemble_model}
\title{Generate samples of parameters from prior distribution}
\usage{
prior_ensemble_model(
  priors,
  M = 1,
  full_sample = TRUE,
  control = list(adapt_delta = 0.95),
  ...
)
}
\arguments{
\item{priors}{An \code{EnsemblePrior} object specifying the prior distributions for the ensemble.}

\item{M}{A \code{numeric} that represents the number of simulators. The default is 1.}

\item{full_sample}{A \code{logical} that runs a full sampling of the prior density of the ensemble model if \code{TRUE}. If \code{FALSE}, returns the point estimate which maximises the prior density of the ensemble model.}

\item{control}{If creating a full sample, this is a named \code{list} of paramaters to control Stan's sampling behaviour. See the documentation of the \code{stan()} function in the \code{rstan} package for details. The default value is \code{list(adapt_delta = 0.95)}. If optimizing, this value is ignored.}

\item{...}{Additional arguments passed to the function \code{rstan::sampling} or  \code{rstan::optimizing}.}
}
\value{
A \code{list} containing two items named \code{samples} and \code{point_estimate}. If \code{full_sample==TRUE}, \code{samples} is a \code{stanfit} and \code{point_estimate} is a \code{NULL} object, else \code{samples} is a \code{NULL} and \code{point_estimate} is a \code{list} object. It is possible to generate a point estimate for the prior if the individual short-term discrepancy prior follows a hierarchical parameterisation.
}
\description{
Methods to generates samples of the parameters from the prior distribution of the ensemble model.
}
\examples{
\donttest{
priors <- EnsemblePrior(4)
prior_density <- prior_ensemble_model(priors, M = 4)
}
}
\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org
}
\seealso{
\code{\linkS4class{EnsembleFit}}
}
