% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_flag_precision.R
\name{ec_flag_precision}
\alias{ec_flag_precision}
\title{Flag occurrences those has bad precision}
\usage{
ec_flag_precision(
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude",
  threshold = 2
)
}
\arguments{
\item{data}{dataframe}

\item{latitude}{decimalLatitude, this a field in the data file. We prefer to use decimalLatitude as accepeted name based on TDWG standards}

\item{longitude}{decimalLongitude, this a field in the data file. We prefer to use decimalLongitude as accepeted name based on TDWG standards}

\item{threshold}{set on 2}
}
\value{
A column which has flagged records represents bad records based on low precision as well as rounding
}
\description{
Flag occurrences those has bad precision
}
\examples{
data <- data.frame(
  species = "A",
  decimalLongitude = c(-120.67, -78, -110, -60, -75.5, -130.78, -10.2, 5.4),
  decimalLatitude = c(20.7, 34.6, 30.0, 10.5, 40.4, 25.66, 15.0, 35.9)
)

data$flag_cordinate_precision <- ec_flag_precision(
  data,
  latitude = "decimalLongitude",
  longitude = "decimalLatitude",
  threshold = 2
)

}
