#' Test dataset for lichen data
#'
#' Data were collected as part of the Northwest Forest Conservation Plan. Data
#' were collected from 300 half-acre (0.2 ha) sites on the Current Vegetation
#' Survey grid in Gifford-Pinchot National Forest, the Umpqua Basin, and the
#' Oregon Coast. Samples were collected between 2002 and 2003. Indicator
#' variables denoted the presence or absence of 7 lichen species. This dataset
#' may be used as a test dataset for the lichen dataset included in this package.
#'
#' @format A data frame with 300 observations and 40 variables. One variable
#' is a location identifier, 7 identify the presence or absence of the lichen
#' species, and 32 are characteristics of the survey site where the data were
#' collected.
#'
#' As with the Lichen Air Quality data, the variables with the suffix Ave
#' in the variable name are the average of 12 monthly variables. The variables
#' with the suffix Diff are contrasts between the sum of the April-September
#' monthly values and the sum of the October-December and January-March
#' monthly values, divided by 12. Roughly speaking, these are
#' summer-to-winter contrasts.
#'
#' The variables are summarized as follows:
#' \describe{
#' \item{PlotNum}{Identifier of the section of forest from which the data were collected.}
#' \item{LobaOreg}{Lobaria oregana (Absent = 0, Present = 1)}
#' \item{LobaPulm}{Lobaria pulmonaria (Absent = 0, Present = 1)}
#' \item{NephBell}{Nephroma bellum (Absent = 0, Present = 1)}
#' \item{NephHelv}{Nephroma helveticum (Absent = 0, Present = 1)}
#' \item{PseuAnom}{Pseudocyphellaria anomala (Absent = 0, Present = 1)}
#' \item{PseuAnth}{Pseudocyphellaria anthraspis (Absent = 0, Present = 1)}
#' \item{PseuCroc}{Pseudocyphellaria crocata (Absent = 0, Present = 1)}
#' \item{EvapoTransAve}{Average monthly potential evapotranspiration in mm}
#' \item{EvapoTransDiff}{Summer-to-winter difference in monthly potential evapotranspiration in mm}
#' \item{MoistIndexAve}{Average monthly moisture index in cm}
#' \item{MoistIndexDiff}{Summer-to-winter difference in monthly monthly moisture index in cm}
#' \item{PrecipAve}{Average monthly precipitation in cm}
#' \item{PrecipDiff}{Summer-to-winter difference in monthly precipitation in cm}
#' \item{RelHumidAve}{Average monthly relative humidity in percent}
#' \item{RelHumidDiff}{Summer-to-winter difference in monthly relative humidity in percent}
#' \item{PotGlobRadAve}{Average monthly potential global radiation in kJ}
#' \item{PotGlobRadDiff}{Summer-to-winter difference in monthly potential global radiation in kJ}
#' \item{AveTempAve}{Average monthly average temperature in degrees Celsius}
#' \item{AveTempDiff}{Summer-to-winter difference in monthly average temperature in degrees Celsius}
#' \item{MaxTempAve}{Average monthly maximum temperature in degrees Celsius}
#' \item{MaxTempDiff}{Summer-to-winter difference in monthly maximum temperature in degrees Celsius}
#' \item{MinTempAve}{Average monthly minimum temperature in degrees Celsius}
#' \item{MinTempDiff}{Summer-to-winter difference in monthly minimum temperature in degrees Celsius}
#' \item{DayTempAve}{Mean average daytime temperature in degrees Celsius}
#' \item{DayTempDiff}{Summer-to-winter difference in average daytime temperature in degrees Celsius}
#' \item{AmbVapPressAve}{Average monthly average ambient vapor pressure in Pa}
#' \item{AmbVapPressDiff}{Summer-to-winter difference in monthly average ambient vapor pressure in Pa}
#' \item{SatVapPressAve}{Average monthly average saturated vapor pressure in Pa}
#' \item{SatVapPressDiff}{Summer-to-winter difference in monthly average saturated vapor pressure in Pa}
#' \item{Aspect}{Aspect in degrees}
#' \item{TransAspect}{Transformed Aspect: TransAspect=(1-cos(Aspect))/2}
#' \item{Elevation}{Elevation in meters}
#' \item{Slope}{Percent slope}
#' \item{ReserveStatus}{Reserve Status (Reserve, Matrix)}
#' \item{StandAgeClass}{Stand Age Class (< 80 years, 80+ years)}
#' \item{ACONIF}{Average age of the dominant conifer in years}
#' \item{PctVegCov}{Percent vegetation cover}
#' \item{PctConifCov}{Percent conifer cover}
#' \item{PctBroadLeafCov}{Percent broadleaf cover}
#' \item{TreeBiomass}{Live tree (> 1inch DBH) biomass, above ground, dry weight.}
#' }
#' @source Cutler, D. Richard., Thomas C. Edwards Jr., Karen H. Beard,
#' Adele Cutler, Kyle T. Hess, Jacob Gibson, and Joshua J. Lawler. 2007.
#' Random Forests for Classification in Ecology. Ecology 88(11): 2783-2792.
"lichenTest"
