% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{sens_table}
\alias{sens_table}
\title{Tables for sensitivity analyses}
\usage{
sens_table(meas, q, r = seq(0.1, 0.9, 0.1), muB = NA, sigB = NA, yr, t2)
}
\arguments{
\item{meas}{\code{prop}, \code{Tmin}, or \code{Gmin}}

\item{q}{True effect size that is the threshold for "scientific significance"}

\item{r}{For \code{Tmin} and \code{Gmin}, vector of values to which the proportion of large effect sizes is to be reduced}

\item{muB}{Mean bias factor on the log scale across studies}

\item{sigB}{Standard deviation of log bias factor across studies}

\item{yr}{Pooled point estimate (on log scale) from confounded meta-analysis}

\item{t2}{Estimated heterogeneity (tau^2) from confounded meta-analysis}
}
\description{
Produces table showing the proportion of true effect sizes more extreme than \code{q}
across a grid of bias parameters \code{muB} and \code{sigB} (for \code{meas == "prop"}).
Alternatively, produces a table showing the minimum bias factor (for \code{meas == "Tmin"})
or confounding strength (for \code{meas == "Gmin"}) required to reduce to less than
\code{r} the proportion of true effects more extreme than \code{q}.
}
\details{
For \code{meas=="Tmin"} or \code{meas=="Gmin"}, arguments \code{muB} and
\code{sigB} can be left \code{NA}; \code{r} can also be \code{NA} as
it will default to a reasonable range of proportions. Returns a \code{data.frame}
whose rows are values of \code{muB} (for \code{meas=="prop"}) or of \code{r}
(for \code{meas=="Tmin"} or \code{meas=="Gmin"}). Its columns are values of
\code{sigB} (for \code{meas=="prop"}) or of \code{q} (for \code{meas=="Tmin"}
or \code{meas=="Gmin"}).
Tables for \code{Gmin} will display \code{NaN} for cells corresponding to \code{Tmin}<1,
i.e., for which no bias is required to reduce the effects as specified.
}
\examples{
sens_table( meas="prop", q=log(1.1), muB=c( log(1.1),
log(1.5), log(2.0) ), sigB=c(0, 0.1, 0.2), 
yr=log(2.5), t2=0.1 )

sens_table( meas="Tmin", q=c( log(1.1), log(1.5) ),
yr=log(1.3), t2=0.1 ) 

# Tmin is 1 here because we already have <80\% of effects
#  below log(1.1) even without any confounding
sens_table( meas="Gmin", r=0.8, q=c( log(1.1) ),
yr=log(1.3), t2=0.1 )
}
\keyword{confounding}
\keyword{meta-analysis}
\keyword{sensitivity}
