% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{intrinsic_mean_tube}
\alias{intrinsic_mean_tube}
\title{Calculate Intrinsic Mean of ETReps}
\usage{
intrinsic_mean_tube(tubes, type = "sizeAndShapeAnalysis", plotting = TRUE)
}
\arguments{
\item{tubes}{List of ETReps.}

\item{type}{String, "ShapeAnalysis" or "sizeAndShapeAnalysis" (default is "sizeAndShapeAnalysis").}

\item{plotting}{Logical, enables visualization of the mean (default is TRUE).}
}
\value{
List representing the mean ETRep.
}
\description{
Computes the intrinsic mean of a set of ETReps.
}
\examples{
#Example 1
# Load tubes
data("tube_A")
data("tube_B")
intrinsic_mean<-
  intrinsic_mean_tube(tubes = list(tube_A,tube_B),
                      plotting = FALSE)
# Plotting
plot_Elliptical_Tube(tube = intrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)

#Example 2
data("simulatedColons")
intrinsic_mean<-
  intrinsic_mean_tube(tubes = simulatedColons,
                      plotting = FALSE)
# Plotting
plot_Elliptical_Tube(tube = intrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)
}
