#' Efficient Sequential Testing with Evidence Ratios
#'
#' The \pkg{ESTER} package implements sequential testing based on evidence
#' ratios computed from the Akaike weights of a set of models. These weights
#' are being computed using either the Akaike Information Criterion (AIC) or the
#' Bayesian Information Criterion (BIC).
#'
#' See \code{vignette("ESTER")} for a general introduction and overview.
#'
#' @author Ladislas Nalborczyk \cr
#' Maintainer: Ladislas Nalborczyk <\email{ladislas.nalborczyk@@gmail.com}>
#'
#' @seealso \code{\link{ictab}}, \code{\link{simER}}, \code{\link{distER}},
#' \code{\link{seqER}}, \code{\link{seqERboot}}
#'
#' @docType package
#' @name ESTER
NULL
