% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{safe_save_rds}
\alias{safe_save_rds}
\title{Safe RDS save}
\usage{
safe_save_rds(object, file_path, recursive = TRUE, no_warning = FALSE)
}
\arguments{
\item{object}{R variable or object to save on disk.}

\item{file_path}{Path and name of the save file, as a string.}

\item{recursive}{Should elements of the path other than the last be created?
If \code{TRUE}, behaves like the Unix command \code{mkdir -p}.}

\item{no_warning}{Whether to cancel the warning issued if a directory is created (bool).}
}
\value{
No return value.
}
\description{
Safe version of \code{\link[=saveRDS]{saveRDS()}}.
If the given save path (i.e. \code{dirname(file_path)}) does not exist, it is created instead of raising an error.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
safe_save_rds(c(1, 2, 8), "./some_folder/my_new_folder/my_vector.rds")
\dontshow{
setwd(.old_wd)
}
}
