% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_nn.R
\name{assign_nn}
\alias{assign_nn}
\title{assign_nn}
\usage{
assign_nn(x, y, y.id = "id", k = 10, crs = 32721)
}
\arguments{
\item{x}{{sf} object of source distance criteria or data.frame with "x" and "y" coordinates}

\item{y}{{sf} object of destination distance criteria or data.frame with "x" and "y" coordinates}

\item{y.id}{name of {y} variable for identification. Default "id"}

\item{k}{numeric value for the near neighbor linear criteria, to reduce the computation 
for nearest neighbor by route}

\item{crs}{Coordinate Reference Systems (CRS), used only if x or y are not {sf} . Default = "32721").}
}
\value{
x object with three new variables
\item{nn_id}{y.id of nearest neighbor}
\item{time}{time by car to nearest neighbor in minutes}
\item{dist}{distance by route to nearest neighbor in kilometers}
}
\description{
Add nearest neighbor information by osrm route service
}
\examples{
\donttest{
pop_epp_nn <- assign_nn(x = pop_epp[1:20,], y = centers_epp)
}
}
