#' casedat
#'
#' Data
#'
#' @format This data is from Walker and Kadlec, "A Model for Simulating Phosphorus Concentrations in Waters & Soils Downstream of Everglades Stormwater Treatment Areas", prepared for US Dept of the Interior,  August 1996.
#'\itemize{
#' \item{`case.number`}{ Index value unique for each case}
#' \item{`STA.Name`}{ The name of the Stormwater Treatment Area (STA) where this data originated.}
#' \item{`Receiving.Area`}{ The area which this STA discharges.}
#' \item{`Start.Discharge`}{ The year which this particular STA began discharge operations.}
#' \item{`STA.outflow.TPconc`}{ Outflow total phosphorus concentration (in ug L-1; mirograms per liter) for this STA.}
#' \item{`STA.outflow.vol`}{ Annual outflow discharge volume (in x1000 Acre-Feet Year-1) for this STA.}
#' \item{`FlowPath.width`}{ The width of the downstream flow path (in kilometers).}
#' \item{`Hydroperiod`}{ Average hydroperiod (time above ground surface) of the downstream system (in percent).}
#' \item{`Soil.Depth`}{ Depth of soil (in centimeters).}
#' \item{`Soil.BulkDensity.initial`}{ The initial bulk density prior to dicharge of the soil downstream of the system (in g cm-3).}
#' \item{`Soil.TPConc.initial`}{ The initial total phosphorus concentration of soil prior to discharge downstream of the system (in mg kg-1).}
#' \item{`Vertical.soilTPGradient.initial`}{ The soil total phosphorus concentration gradient prior to dischage downstream of the system (in mg cm-3 cm-1).}
#' \item{`Soil.BulkDensity.final`}{ The final bulk density after dischage of the soil downstream of the system (in g cm-3).}
#' \item{`PSettlingRate`}{ The phosphorus settling rate estimated from steady-state conditions (m Year-1).}
#' \item{`P.AtmoDep`}{ Phosphorus atmospheric depostition loading rate (in mg m-2 Year-1).}
#' \item{`Rainfall`}{ Annual accumulated rainfall estimate (m Year-1).}
#' \item{`ET Annual`}{ evapotranspiration estimate (m Year-1).}
#' }
#' @docType data
#' @keywords dataset
#' @name casedat
#' @source <http://www.wwwalker.net/epgm/>

"casedat"
