% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{clamp.vars}
\alias{clamp.vars}
\title{Clamp predictor variables}
\usage{
clamp.vars(orig.vals, ref.vals, left = NULL, right = NULL, categoricals = NULL)
}
\arguments{
\item{orig.vals}{RasterStack / matrix / data frame: environmental predictor variables (must be in same geographic 
projection as occurrence data), or predictor variables values for the original records}

\item{ref.vals}{matrix / data frame: predictor variable values for the reference records
(not including coordinates), used to determine the minimums and maximums -- 
this should ideally be the occurrences + background (can be made with raster::extract())}

\item{left}{character vector: names of variables to get a minimum clamp; can be "none" to turn
off minimum clamping}

\item{right}{character vector: names of variables to get a maximum clamp, can be "none" to turn
off maximum clamping}

\item{categoricals}{character vector: name or names of categorical environmental variables}
}
\value{
The clamped Raster* object.
}
\description{
This function restricts the values of one or more predictor variable rasters
to stay within the bounds of the input occurrence and background data (argument "ref.vals").
This is termed "clamping", and is mainly used to avoid making extreme extrapolations
when making model predictions to environmental conditions outside the range of the
occurrence / background data used to train the model. Clamping can be done on variables of
choice on one or both tails of their distributions (i.e., arguments "left" and "right" for
minimum and maximum clamps, respectively). If "left" and/or "right" are not specified and 
left at the default NULL, the function will clamp all variables for that tail (thus, the 
function default is to clamp all variables on both sides). To turn off clamping for one side, 
enter "none" for either "left" or "right".

Categorical variables need to be declared with the argument "categoricals". These variables
are excluded from the clamping analysis, but are put back into the RasterStack that is returned.
}
\author{
Stephen J. Phillips, Jamie M. Kass, Gonzalo Pinilla-Buitrago
}
