% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.overlap.R
\name{env.overlap}
\alias{env.overlap}
\title{Calculates overlap between models in environment space using latin hypercube sampling}
\usage{
env.overlap(
  model.1,
  model.2,
  env,
  tolerance = 0.001,
  max.reps = 10,
  cor.method = "spearman",
  chunk.size = 1e+05,
  recal.model.1 = NA,
  recal.model.2 = NA
)
}
\arguments{
\item{model.1}{An enmtools.model object model object that can be projected using the predict() function}

\item{model.2}{Another enmtools.model object or other model object that can be projected using the predict() function}

\item{env}{A raster, raster stack of environmental data, or a list of minima and maxima for the environmental space to evaluate models over}

\item{tolerance}{How close do successive overlap metrics have to be before we decide we're close enough to the final answer}

\item{max.reps}{Maximum number of attempts that will be made to find suitable starting conditions}

\item{cor.method}{Which method to use for calculating correlations between models}

\item{chunk.size}{How many combinations of environmental variables to try at a time.  If your niche breadth in environment space is small, increasing this value may help you get a result.}

\item{recal.model.1}{Optional.  The output of enmtools.recalibrate for model 1, which needs to have been run with "recalibrate = TRUE".}

\item{recal.model.2}{Optional.  The output of enmtools.recalibrate for model 2, which needs to have been run with "recalibrate = TRUE".}
}
\value{
A list of values measuring the overlap between models in environment space, as well as some plots depicting change of the estimates as a function of how many samples were used, which are included as a sort of convergence diagnostic.
}
\description{
Calculates overlap between models in environment space using latin hypercube sampling
}
\examples{
data(iberolacerta.clade)
data(euro.worldclim)
cyreni <- iberolacerta.clade$species$cyreni
monticola <- iberolacerta.clade$species$monticola
cyreni.glm <- enmtools.glm(cyreni, euro.worldclim, f = pres ~ bio1 + bio12, nback = 500)
monticola.glm <- enmtools.glm(monticola, euro.worldclim, f = pres ~ bio1 + bio12, nback = 500)
env.overlap(cyreni.glm, monticola.glm, euro.worldclim)
}
