% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emprec.R
\name{em.prec}
\alias{em.prec}
\title{EM algorithm for multivariate normal, precision matrix parameterization}
\usage{
em.prec(
  dat,
  max.iter = 500,
  tol = 1e-05,
  start = c("diag", "pairwise", "listwise", "full"),
  glassoversion = c("none", "glassoFast", "glasso", "glassonostart"),
  debug = 0,
  ...
)
}
\arguments{
\item{dat}{Data frame or matrix that contains the raw data.}

\item{max.iter}{Max number of EM cycles.}

\item{tol}{Tolerance for change in parameter estimates across EM Cycles. If
all changes are less than \code{tol}, the algorithm terminates.}

\item{start}{Starting value method (see details).}

\item{glassoversion}{Character indicating whether to do regularization (lasso),
and if so, using which package. "glasso" uses the \code{\link[glasso]{glasso}}
function and uses the E-step covariance matrix for starting values,
"glassoFast" uses \code{\link{glassoFast}{glassoFast}} which also
penalizes the diagonal of the precision matrix by default (glasso does not),
"glassonostart" also uses \code{\link[glasso]{glasso}} but no "warm" starting
values.}

\item{debug}{(Experimental) set an integer value > 1 for some information as the algorithm runs.}

\item{...}{Arguments passed down to any of the glasso functions.}
}
\value{
A list with the following:
\itemize{
 \item{\code{p.est}: all parameter estimates as a vector (means followed by unique elements of precision matrix).}
 \item{\code{mu}: estimated means.}
 \item{\code{S}: estimated covariance matrix.}
 \item{\code{K}: estimated precision matrix.}
 \item{\code{it}: number of EM cycles completed.}
 \item{\code{conv}: boolean value indicating convergence (TRUE) or not (FALSE).}
}
}
\description{
EM algorithm for multivariate normal, precision matrix parameterization
}
\details{
This function computes all means and the precision matrix (inverse of covariance
matrix) among a set of variables using the Expectation-Maximization (EM)
algorithm to handle missing values, and assuming multivariate normality. The
EM code was originally developed based on Stadler and Buhlmann (2012) and for
use with the graphical lasso (i.e., glasso). This version allows the possibility
of using a lasso by specifying something other than "none" for \code{glassoversion}.
However, it can also be used without regularization to just estimate the precision matrix.

For starting values for the EM algorithm itself (not at the M-step), the
function accepts either a list that has \code{mu} and \code{S} slots
corresponding to the starting mean and covariance matrix. This is useful if
the user would like to use custom starting values. Otherwise, a character
corresponding to any of the options available in the \code{\link{startvals.cov}}
function will be used to take a guess at starting values.
}
\examples{
\donttest{
  library(psych)
  data(bfi)
  test <- em.prec(bfi[,1:25])
}
}
\references{
Städler, N., & Bühlmann, P. (2012). Missing values: sparse inverse covariance estimation and an
  extension to sparse regression. Statistics and Computing, 22, 219–235. \doi{10.1007/s11222-010-9219-7}
}
