% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{smth}
\alias{smth}
\alias{smth,binClst-method}
\title{Posterior smoothing of single local labels.}
\usage{
smth(obj, dlta = 1)

\S4method{smth}{binClst}(obj, dlta = 1)
}
\arguments{
\item{obj}{A \code{binClst_instance}.}

\item{dlta}{A numeric value in the range (0,1) (default is 1) indicating the
  user's will to accept a change of label. The change of label is done
  whenever the decrease in likelihood is not greater then \code{dlta}.}
}
\value{
A smoothed copy of the input instance.
}
\description{
\code{smth} Performs a posterior smoothing of single local
  labels (locations that differ from their neighbouring locations while the
  later have equal labels).
}
\examples{
# -- cluster the example path with a prior smooth of 1 hour --
mysmoothbcp <- stbc(expth,smth=1,info=-1)
# -- apply a posterior smoothing --
mysmoothbcpsmoothed <- smth(mysmoothbcp,dlta=0.5)
}

