% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/test.l.max.R
\name{test.l.max}
\alias{test.l.max}
\title{Function to find maximum possible l value.}
\usage{
test.l.max(X, n = 10, ...)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{n}{Numeric scalar, number of loop runs and values per loop.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
A numeric scalar, maximal possible l value.
}
\description{
This function approximates the highest possible value for l in a nested
loop.
}
\examples{
## load example data set
data(X, envir = environment())

## create weight transformation limits vector
l <- seq(from = 0, to = 0.6, by = 0.02)

## test l.max
l.max <- test.l.max(X = X)
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180. \cr
Klovan JE, Imbrie J. 1971. An Algorithm and FORTRAN-IV Program for
Large-Scale Q-Mode Factor Analysis and Calculation of Factor Scores.
Mathematical Geology 3: 61-77.
}
\seealso{
\code{\link{EMMA}}, \code{\link{check.data}},
\code{\link{test.parameters}}
}
\keyword{EMMA}

