% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{gd_summary.emc}
\alias{gd_summary.emc}
\alias{gd_summary}
\title{Gelman-Rubin Statistic}
\usage{
\method{gd_summary}{emc}(
  emc,
  selection = "mu",
  omit_mpsrf = TRUE,
  stat = "max",
  stat_only = FALSE,
  digits = 3,
  ...
)

gd_summary(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character vector. Indicates which parameter types to check (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{omit_mpsrf}{Boolean. If \code{TRUE} also returns the multivariate point scale reduction factor (see \code{?coda::gelman.diag}).}

\item{stat}{A string. Should correspond to a function that can be applied to a vector,
which will be performed on the vector/rows or columns of the matrix of the parameters}

\item{stat_only}{Boolean. If \code{TRUE} will only return the result of the applied stat function,
otherwise returns both the stat result and the result of the function on all parameters.}

\item{digits}{Integer. How many digits to round the output to}

\item{...}{Optional additional arguments that can be passed to \code{get_pars}}
}
\value{
A matrix or vector of R-hat values for the selected parameter type.
}
\description{
Returns the Gelman-Rubin diagnostics (otherwise known as the R-hat) of the selected parameter type;
i.e. the ratio of between to within MCMC chain variance.
}
\details{
See: Gelman, A and Rubin, DB (1992)
Inference from iterative simulation using multiple sequences, \emph{Statistical Science}, 7, 457-511.

Full range of possible samples manipulations described in \code{get_pars}.
}
\examples{
gd_summary(samples_LNR, selection = "correlation", stat = "mean", flatten = TRUE)
}
