% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{pairs_posterior}
\alias{pairs_posterior}
\title{Plot within-chain correlations}
\usage{
pairs_posterior(
  emc,
  selection = "alpha",
  scale_subjects = TRUE,
  do_plot = TRUE,
  N = 500,
  ...
)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character string. Indicates which parameter type to
plot (\code{alpha}, \code{mu}, \code{variance}, \code{covariance}, \code{correlation}).}

\item{scale_subjects}{Boolean. To standardize each participant with \code{selection = "alpha"},
by subtracting the mean and divding by the standard deviation. This ensures the plot has every participant on the same scale.}

\item{do_plot}{Boolean. Whether to plot the pairs plot, if \code{FALSE}, only the correlations
are returned.}

\item{N}{Integer for maximum number of iterations used (defaults to 500).
If number of samples in stage or selection exceeds N, a random subset will be taken of size N}

\item{...}{Optional arguments that can be passed to \code{get_pars}}
}
\value{
Invisibly returns a matrix with the correlations between the parameters.
}
\description{
Plots within-chain parameter correlations (upper triangle) and corresponding
scatterplots (lower triangle) to visualize parameter sloppiness.
}
\details{
If \code{selection = alpha} the parameter chains are concatenated across participants,
(after standardizing if \code{scale_subjects = TRUE}) and then correlated.
}
\examples{
\donttest{
# Plot the sloppiness for the individual-level subjects
pairs_posterior(samples_LNR, selection = "alpha")

# We can also choose group-level parameters and subsets of the parameter space
pairs_posterior(samples_LNR, use_par = c("m", "t0"), selection = "sigma2")
}
}
