% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{get_BayesFactor}
\alias{get_BayesFactor}
\title{Bayes Factors}
\usage{
get_BayesFactor(MLL1, MLL2)
}
\arguments{
\item{MLL1}{Numeric. Marginal likelihood of model 1. Obtained with \code{run_bridge_sampling()}}

\item{MLL2}{Numeric. Marginal likelihood of model 2. Obtained with \code{run_bridge_sampling()}}
}
\value{
The BayesFactor for model 1 over model 2
}
\description{
returns the Bayes Factor for two models
}
\examples{
\dontrun{
# First get the marginal likelihood for two_models
# Here the full model is an emc object with the hypothesized effect
# The null model is an emc object without the hypothesized effect
MLL_full <- run_bridge_sampling(full_model, cores_per_prop = 3)
MLL_null <- run_bridge_sampling(null_model, cores_per_prop = 3)
# Now we can calculate their Bayes factor
get_BayesFactor(MLL_full, MLL_null)
}
}
