% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventmerge.R
\name{eventmerge}
\alias{eventmerge}
\title{Merge Mobile EMA (mEMA) event-level data into momentary data}
\usage{
eventmerge(MOMENTARY, EVENT, eventNAME = "eventYN")
}
\arguments{
\item{MOMENTARY}{a dataframe with momentary (i.e., level-1) data exported from mEMA, should have the following columns (all mEMA default names): KEY, instance_key, subject_id,timestamp}

\item{EVENT}{a dataframe with event data (i.e., level-2) that should have the following columns (all mEMA default): instance_key    subject_id    respondent_id    timestamp    local_date    survey_id    timezone_offset    as well as an "event" column in the last column of the dataframe (can be any name)}

\item{eventNAME}{variable name for your event in the final merged dataset (does not have to match last column in EVENT dataset, but can). Defaults to "eventYN".}
}
\value{
A dataframe that contains event data merged into your momentary data. It will have N rows = N rows in the momentary dataset.
}
\description{
This allows you to merge event-level data (e.g., yes/no to an event) into momentary data, placing the event with the most recent momentary datapoint before the event
}
\examples{
\dontrun{newDATA<-eventmerge(MOMENTARYdata,EVENTdata,eventNAME="eventYN")}
}
\keyword{merging}
