% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Emas.R
\name{Emas}
\alias{Emas}
\title{Epigenome-Wide Mediation Analysis Study}
\usage{
Emas(
  data,
  M.matrix,
  id = "",
  x = "",
  y = "",
  x.cov = c(),
  y.cov = c(),
  m.cov = c(),
  ini.sims = 100,
  boot = FALSE,
  cl.n = 1,
  ...
)
}
\arguments{
\item{data}{A data.frame included id, x, y, x.cov, y.cov, m.cov.}

\item{M.matrix}{A matrix with the epigenome-wide CpG information, maybe a M-value matrix or a beta value matrix.}

\item{id}{Variable name of the id.}

\item{x, y}{Variable name of exposure(x) and outcome(y).}

\item{x.cov}{Variable names of covariates related to exposure(x).}

\item{y.cov}{Variable names of covariates related to outcome(y).}

\item{m.cov}{Variable names of covariates related to mediator(m).}

\item{ini.sims}{Initial number of Monte Carlo draws for nonparametric bootstrap or quasi-Bayesian approximation.}

\item{boot}{A logical value. if 'FALSE' a quasi-Bayesian approximation is used for confidence intervals; if 'TRUE' nonparametric bootstrap will be used. Default is 'FALSE'.}

\item{cl.n}{Number of cores used for parallel computing.}

\item{...}{Other arguments passed to \code{mediated} and \code{boot}.}
}
\value{
\code{Emas} returns a data.frame with the average mediation effects(AME), 
   average direct effects(ADE), total effects, mediation proportion.
   
   AMEEst: Point estimates for average mediation effects under the exposure conditions.
   
   AMElow95, AMEupp95: 95 percentage confidence intervals for average mediation effects.
   
   AME.P: Two-sided p-values for average mediation effects.
   
   ADEEst: Point estimates for average direct effect under the exposure conditions.
   
   ADElow95, ADEupp95: 95 percentage confidence intervals for average direct effects.
   
   ADE.P: Two-sided p-values for average direct effects.
   
   TotEst: Point estimate for total effect.
   
   Totlow95, Totupp95: 95 percentage confidence interval for total effect.
   
   Tot.P: Two-sided p-values for total effect.
   
   PropEst: The 'proportions mediated', or the size of the average mediation effects relative to the total effect.
   
   Proplow95, Propupp95: 95 percentage confidence intervals for the proportions mediated.
   
   Prop.p: Two-sided p-values for proportions mediated.
}
\description{
This function can perform the Epigenome-Wide Mediation Analysis Study (EMAS).
}
\details{
This function can perform the Epigenome-Wide Mediation Analysis Study (EMAS) to explore the potential mediating CpG sites of exposure variables affecting outcome variables within the epigenome-wide.
}
\examples{
\donttest{data(data.m)
data(Mvalue)
E.result <- Emas(data.m, Mvalue, id = "ID", x = "x", y = "y",
                 x.cov = c("age", "gender"),
                 y.cov = c("age", "gender"),
                 m.cov = c("age", "gender", "CD8T", "CD4T"), 
                 ini.sims = 100, boot = FALSE, cl.n = 1)}
}
\references{
Tingley, D., Yamamoto, T., Hirose, K., Imai, K. and Keele, L. (2014). mediation: R package for Causal Mediation Analysis.
\emph{Journal of Statistical Software}, 59(5), 1–38. \doi{doi:10.18637/jss.v059.i05}.
}
\author{
Xiuquan Nie, niexiuquan1995@foxmail.com
}
