% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambda.find.glm}
\alias{lambda.find.glm}
\title{To calculate tuning parameter involved in ELCIC under GLM}
\usage{
lambda.find.glm(x, y, beta, dist)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should contain all ones corresponding to the intercept.}

\item{y}{A vector containing outcomes.}

\item{beta}{A plug-in estimator solved by an external estimating procedure.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}
}
\value{
A value of lambda (tuning parameter) vector involved in the empirical likelihood.
}
\description{
This function aims to efficiently calculate the tuning parameter lambda in ELCIC.
}
\note{
All "x" and "y" should be observed.
}
\examples{
## tests
# load data
data(glmsimdata)
x<-glmsimdata$x
y<-glmsimdata$y
# obtain the estimates
fit<-glm(y~x-1,family="poisson")
beta<-fit$coefficients
lambda<-lambda.find.glm(x, y, beta, dist="poisson")
lambda

}
