% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_functions.R
\name{glm.generator}
\alias{glm.generator}
\title{Cross-sectional data generation under GLM}
\usage{
glm.generator(beta, samplesize, rho = 0, dist, sd.gaussian = NULL, ov = NULL)
}
\arguments{
\item{beta}{The underlying true coefficient for each covariates in the model (including the intercept).}

\item{samplesize}{The sample size.}

\item{rho}{The correlation coefficient among covariates.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{sd.gaussian}{The standard deviation for the outcome from Gaussian distribution.}

\item{ov}{The dispersion parameter for the outcome from Negative Binomial distribution.}
}
\value{
x: a matrix containing continuous covariates. The first column should contain all ones corresponding to the intercept.

y: a vector containing outcomes.
}
\description{
A function provides simulated outcomes as well as covariates under the framework of GLM. All covariates (except for intercept) are normally distributed.
}
\examples{
beta<-c(0.5,0.5,0.5,0)
samplesize<-100
data<-glm.generator(beta=beta,samplesize=samplesize,rho=0.5,dist="poisson")

}
