% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{blockSample}
\alias{blockSample}
\title{blockSample}
\usage{
blockSample(localSample, blockLength, startSeed = NA)
}
\arguments{
\item{localSample}{Sample data frame}

\item{blockLength}{integer size of subset, expressed in days.  200 days has been found to be a good choice.}

\item{startSeed}{setSeed value. This is used to make repeatable output. Default = NA.}
}
\value{
newSample data frame in same format as Sample data frame.  It has the same number of rows as the Sample data frame.
}
\description{
Get a bootstrap replicate of the Sample data frame based on the user-specified blockLength. 
The bootstrap replicate is made up randomly selected blocks of 
data from Sample data frame.  Each block includes all the samples in a standard period of time (the blockLength measured in days).
The blocks are created based on the random selection (with 
replacement) of starting dates from the full Sample data frame.  The bootstrap replicate  
has the same number of observations as the original Sample, but some 
observations are included once, some are included multiple times, and some are not 
included at all.
}
\examples{
library(EGRET)
eList <- Choptank_eList
Sample <- eList$Sample
bsReturn <- blockSample(Sample, 200)
}
\keyword{WRTDS}
\keyword{quality}
\keyword{water}
