% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFourStats.R
\name{plotFourStats}
\alias{plotFourStats}
\title{Makes four graphs of annual streamflow statistics on a single page}
\usage{
plotFourStats(eList, yearStart = NA, yearEnd = NA, printTitle = TRUE,
  runoff = FALSE, cex.main = 1.2, qUnit = 1, cex.axis = 1.2,
  cex = 0.8, col = "black", lwd = 1, ...)
}
\arguments{
\item{eList}{named list with at least Daily and INFO dataframes}

\item{yearStart}{A numeric value for year in which the graph should start, default is NA, which indicates that the graph should start with first annual value}

\item{yearEnd}{A numeric value for year in which the graph should end, default is NA, which indicates that the graph should end with last annual value}

\item{printTitle}{logical variable, if TRUE title is printed, if FALSE title is not printed, default is TRUE}

\item{runoff}{logical variable, if TRUE the streamflow data are converted to runoff values in mm/day}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{qUnit}{object of qUnit class \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width. Default is 1.}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
Part of the flowHistory system.  The four statistics are 1-day maximum, annual mean, annual median, and annual 7-day minimum.
 Although there are a lot of optional arguments to this function, most are set to a logical default.
 
Data come from named list, which contains a Sample dataframe with the sample data, 
a Daily dataframe with the daily flow data,
and an INFO dataframe with metadata. Each graph shows a loess smooth of the data that are plotted.
}
\examples{
eList <- Choptank_eList
\donttest{
# Water year:
plotFourStats(eList)
# Graphs consisting of Jun-Aug
eList <- setPA(eList,paStart=6,paLong=3)
plotFourStats(eList)
}
}
\seealso{
\code{\link{plotFlowSingle}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{streamflow}
