% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateSiteINFO.r
\name{populateSiteINFO}
\alias{populateSiteINFO}
\title{Populate Site Information Columns}
\usage{
populateSiteINFO(INFO, siteNumber, interactive = TRUE)
}
\arguments{
\item{INFO}{dataframe with value and code columns}

\item{siteNumber}{character USGS site number}

\item{interactive}{logical Option for interactive mode.  If TRUE, there is user interaction for error handling 
and data checks. Default is TRUE. If running in batch, should be set to FALSE.}
}
\value{
INFO dataframe
}
\description{
Populates INFO data frame with additional user-supplied information. Also removes fields not related to WRTDS study.
}
\examples{
\dontrun{
library(dataRetrieval)
INFO <- readNWISsite('01594440')
siteNumber <- "01594440"
siteINFO <- populateSiteINFO(INFO, siteNumber)
}
}
