% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierEGA.R
\name{hierEGA}
\alias{hierEGA}
\title{Hierarchical \code{\link[EGAnet]{EGA}}}
\usage{
hierEGA(
  data,
  loading.method = c("BRM", "experimental"),
  rotation = NULL,
  scores = c("factor", "network"),
  loading.structure = c("simple", "full"),
  impute = c("mean", "median", "none"),
  corr = c("auto", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  model = c("BGGM", "glasso", "TMFG"),
  lower.algorithm = "louvain",
  higher.algorithm = c("leiden", "louvain", "walktrap"),
  uni.method = c("expand", "LE", "louvain"),
  plot.EGA = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis
(does not accept correlation matrices)}

\item{loading.method}{Character (length = 1).
Sets network loading calculation based on implementation
described in \code{"BRM"} (Christensen & Golino, 2021) or
an \code{"experimental"} implementation.
Defaults to \code{"BRM"}}

\item{rotation}{Character.
A rotation to use to obtain a simpler structure. 
For a list of rotations, see \code{\link[GPArotation]{rotations}} for options.
Defaults to \code{NULL} or no rotation.
By setting a rotation, \code{scores} estimation will be
based on the rotated loadings rather than unrotated loadings}

\item{scores}{Character (length = 1).
How should scores for the higher-order structure be estimated?
Defaults to \code{"network"} for network scores computed using
the \code{\link[EGAnet]{net.scores}} function.
Set to \code{"factor"} for factor scores computed using
\code{\link[psych]{fa}}. Factors scores will be based on
\strong{EFA} (as in Jiménez et al., 2023)

\emph{Factor scores use the number of communities from 
\code{\link[EGAnet]{EGA}}. Estimated factor loadings may 
not align with these communities. The plots using factor scores 
will have higher order factors that may not completely map on to 
the lower order communities. Look at
\code{$hierarchical$higher_order$lower_loadings} to determine the 
composition of the lower order factors.}}

\item{loading.structure}{Character (length = 1).
Whether simple structure or the saturated loading matrix
should be used when computing scores (\code{scores = "network"} only).
Defaults to \code{"simple"}

\code{"simple"} structure more closely mirrors traditional
hierarchical factor analytic methods such as CFA; \code{"full"}
structure more closely mirrors EFA methods

Simple structure is the more conservative (established) approach
and is therefore the default. Treat \code{"full"} as experimental
as proper vetting and validation has not been established}

\item{impute}{Character (length = 1).
If there are any missing data, then imputation can be implemented. 
Available options:

\itemize{

\item{\code{"none"} --- }
{Default. No imputation is performed}

\item{\code{"mean"} --- }
{The mean value of each variable is used to replace missing data
for that variable}

\item{\code{"median"} --- }
{The median value of each variable is used to replace missing data
for that variable}

}}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item{\code{"auto"} --- }
{Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)}

\item{\code{"pearson"} --- }
{Pearson's correlation is computed for all variables regardless of
categories}

\item{\code{"spearman"} --- }
{Spearman's rank-order correlation is computed for all variables
regardless of categories}

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item{\code{"pairwise"} --- }
{Computes correlation for all available cases between
two variables}

\item{\code{"listwise"} --- }
{Computes correlation for all complete cases in the dataset}

}}

\item{model}{Character (length = 1).
Defaults to \code{"glasso"}.
Available options:

\itemize{

\item{\code{"BGGM"} --- }
{Computes the Bayesian Gaussian Graphical Model.
Set argument \code{ordinal.categories} to determine
levels allowed for a variable to be considered ordinal.
See \code{\link[BGGM]{estimate}} for more details}

\item{\code{"glasso"} --- }
{Computes the GLASSO with EBIC model selection.
See \code{\link[EGAnet]{EBICglasso.qgraph}} for more details}

\item{\code{"TMFG"} --- }
{Computes the TMFG method.
See \code{\link[EGAnet]{TMFG}} for more details}

}}

\item{lower.algorithm}{Character or 
\code{\link{igraph}} \code{cluster_*} function (length = 1).
Defaults to the lower order \code{"louvain"} with most common 
consensus clustering (1000 iterations; see 
\code{\link[EGAnet]{community.consensus}} for more details)

Louvain with consensus clustering is \emph{strongly}
recommended. Using any other algorithm is considered
\emph{experimental} as they have not been designed to
capture lower order communities}

\item{higher.algorithm}{Character or 
\code{\link{igraph}} \code{cluster_*} function (length = 1).
Defaults to \code{"walktrap"}.
Three options are listed below but all are available
(see \code{\link[EGAnet]{community.detection}} for other options):

\itemize{

\item{\code{"leiden"} --- }
{See \code{\link[igraph]{cluster_leiden}} for more details}

\item{\code{"louvain"} --- }
{By default, \code{"louvain"} will implement the Louvain algorithm using 
the consensus clustering method (see \code{\link[EGAnet]{community.consensus}} 
for more information). This function will implement
\code{consensus.method = "most_common"} and \code{consensus.iter = 1000} 
unless specified otherwise}

\item{\code{"walktrap"} --- }
{See \code{\link[igraph]{cluster_walktrap}} for more details}

}

Using \code{algorithm} will set only \code{higher.algorithm} and
\code{lower.algorithm} will default to Louvain with most common
consensus clustering (1000 iterations)}

\item{uni.method}{Character (length = 1).
What unidimensionality method should be used? 
Defaults to \code{"louvain"}.
Available options:

\itemize{

\item{\code{expand} --- }
{Expands the correlation matrix with four variables correlated 0.50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This method was used in the Golino et al.'s (2020)
\emph{Psychological Methods} simulation}

\item{\code{LE} --- }
{Applies the Leading Eigenvector algorithm
(\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the Leading Eigenvector solution is used; otherwise, regular EGA
is used. This method was used in the Christensen et al.'s (2023) 
\emph{Behavior Research Methods} simulation}

\item{\code{louvain} --- }
{Applies the Louvain algorithm (\code{\link[igraph]{cluster_louvain}})
on the empirical correlation matrix. If the number of dimensions is 1, 
then the Louvain solution is used; otherwise, regular EGA is used. 
This method was validated Christensen's (2022) \emph{PsyArXiv} simulation.
Consensus clustering can be used by specifying either
\code{"consensus.method"} or \code{"consensus.iter"}}

}}

\item{plot.EGA}{Boolean.
If \code{TRUE}, returns a plot of the network and its estimated dimensions.
Defaults to \code{TRUE}}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{FALSE} (silent calls).
Set to \code{TRUE} to see all messages and warnings for every function call}

\item{...}{Additional arguments to be passed on to
\code{\link[EGAnet]{auto.correlate}},
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.detection}},
\code{\link[EGAnet]{community.consensus}},
\code{\link[EGAnet]{EGA}}, and
\code{\link[GPArotation]{rotations}}}
}
\value{
Returns a list of lists containing:

\item{lower_order}{\code{\link[EGAnet]{EGA}} results for the lower order structure}

\item{higher_order}{\code{\link[EGAnet]{EGA}} results for the higher order structure}

\item{parameters}{A list containing \code{lower_loadings} and \code{lower_scores}
that were used to estimate scores and the higher order \code{\link[EGAnet]{EGA}}
results, respectively}

\item{dim.variables}{A data frame with variable names and their lower and higher 
order assignments}

\item{TEFI}{Generalized TEFI using \code{\link[EGAnet]{tefi}}}

\item{plot.hierEGA}{Plot output if \code{plot.EGA = TRUE}}
}
\description{
Estimates EGA using the lower-order solution of the Louvain
algorithm (\code{\link[igraph]{cluster_louvain}})to identify the lower-order 
dimensions and then uses factor or network loadings to estimate factor 
or network scores, which are used to estimate the higher-order dimensions
(for more details, see Jiménez et al., 2023)
}
\examples{
# Example using network scores
opt.hier <- hierEGA(
  data = optimism, scores = "network",
  plot.EGA = FALSE # No plot for CRAN checks
)

\donttest{
# Plot multilevel plot
plot(opt.hier, plot.type = "multilevel")

# Plot multilevel plot with higher order
# border color matching the corresponding 
# lower order color
plot(opt.hier, color.match = TRUE)

# Plot levels separately
plot(opt.hier, plot.type = "separate")}

}
\references{
\strong{Hierarchical EGA simulation} \cr
Jiménez, M., Abad, F. J., Garcia-Garzon, E., Golino, H., Christensen, A. P., & Garrido, L. E. (2023). 
Dimensionality assessment in bifactor structures with multiple general factors: A network psychometrics approach. 
\emph{Psychological Methods}.

\strong{Conceptual implementation} \cr
Golino, H., Thiyagarajan, J. A., Sadana, R., Teles, M., Christensen, A. P., & Boker, S. M. (2020).
Investigating the broad domains of intrinsic capacity, functional ability and
environment: An exploratory graph analysis approach for improving analytical
methodologies for measuring healthy aging.
\emph{PsyArXiv}.
}
\seealso{
\code{\link[EGAnet]{plot.EGAnet}} for plot usage in \code{\link{EGAnet}}
}
\author{
Marcos Jiménez <marcosjnezhquez@gmailcom>,
Francisco J. Abad <fjose.abad@uam.es>,
Eduardo Garcia-Garzon <egarcia@ucjc.edu>,
Hudson Golino <hfg9s@virginia.edu>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>, and
Luis Eduardo Garrido <luisgarrido@pucmm.edu.do>
}
