% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_eval.R
\name{efs_eval}
\alias{efs_eval}
\title{Evaluation of Ensemble Features Selection}
\usage{
efs_eval(data, efs_table, file_name, classnumber, NA_threshold, logreg = TRUE,
  rf = TRUE, permutation = TRUE, p_num = 100, variances = TRUE,
  jaccard = TRUE, bs_num = 100, bs_percentage = 0.9)
}
\arguments{
\item{data}{an object of class data.frame}

\item{efs_table}{a table object of class matrix (retrieved
from \code{ensemble_fs})}

\item{file_name}{a character string, name which is used for the two 
possible PDF files.}

\item{classnumber}{a number indicating the index of variable for binary classification}

\item{NA_threshold}{a number in range of [0,1]. Threshold for deletion
of features with a greater proportion of NAs than \code{NA_threshold}.}

\item{logreg}{a logical value indicating whether to conduct an evaluation 
via logistic regression or not}

\item{rf}{a logical value indicating whether to conduct an evaluation 
via random forest or not}

\item{permutation}{a logical value indicating whether to conduct a permutation 
of the class variable or not}

\item{p_num}{number of permutations}

\item{variances}{a logical value indicating whether to calculate the variances 
of importances retrieved from bootrapping or not}

\item{jaccard}{a logical value indicating whether to calculate the jaccard-index or not}

\item{bs_num}{a number of boostrap permutations of the importances}

\item{bs_percentage}{a number in range of [0,1]. Proportion of randomly selected samples for boostraping}
}
\value{
An object of class list, with the following components: 
\cr "AUC of LR with all parameters",
\cr "AUC of LR with EFS parameter" 
\cr "P-value of LR-ROC test",
#' \cr "AUC of RF with all parameters",
\cr "AUC of RF with EFS parameter" 
\cr "P-value of RF-ROC test",
\cr "P-value of permutation", 
\cr "Variances of feature importances",
\cr "Jaccard-index".
}
\description{
Provides several evaluation tests of
 the ouput of \code{\link{ensemble_fs}}. There are
 performance test, namely the logreg test and permutation 
 test as well as tests of stability via the variance 
 of feature importances and the Jaccard-index (see Details).
}
\details{
A logistic regression model with leave-one-out cross-validation (LOOCV) of the
 selected features and of all feature is conducted by \code{logreg = TRUE}.
 Both AUC-values of the ROC curves are compared with \code{\link{roc.test}}.
 The ROC curves are illustrated on the PDF file "file_name" + "LG-ROC.pdf".
 \cr 
 By \code{rf = TRUE}, random forst model will be constructed and evaluated.
 Parallel to Logreg, the AUC-values of the two ROC curves of all features and a subset  
 of the best ranked feautres are compared with \code{\link{roc.test}}.
 The ROC curves are illustrated on the PDF file "file_name" + "RF-ROC.pdf".
 \cr
 \cr The permutation test (\code{permutation = TRUE}) compares the AUC outcome of 
 an logistic regression with \code{p_num} AUCs from random 
 permutations of the class variable by a \code{\link{t.test}}.
 \cr 
 \cr Variances of the importances after a bootstrapping analysis are 
 calculated by \code{variances = TRUE}. Thereby the number and proportion
 of the bootstrapping can be set by \code{bs_num} and \code{bs_percentage}.
 The function also provides a PDF file "file_name" +"_Variances.pdf".
 Additionally, the Jaccard-index of this bootstrapped importances 
 can be calculated by setting \code{jaccard=TRUE}.
}
\examples{
 ## Loading dataset in environment
 data(efsdata)
 ## Generate a ranking based on importance (with default
 ## NA_threshold = 0.7,cor_threshold = 0.2)
 efs<-ensemble_fs(efsdata,5,runs=2)
 ## Conduct AUC test and permutation test
 eval_example <- efs_eval(data = efsdata, efs_table = efs, file_name = 'eval_test', 
                      classnumber = 5, NA_threshold = 0.2,
                      logreg = TRUE,
                      rf = FALSE,
                      permutation = TRUE, p_num = 2, 
                      variances = FALSE, jaccard = FALSE)
## Calculating variances and the Jaccard-index can take several minutes computation time 
}
\seealso{
\link[stats]{glm}, \link[pROC]{roc},\link[ROCR]{prediction}, \link[graphics]{boxplot}, \link[utils]{tail}, \link[stats]{t.test}
}
\author{
Ursula Neumann
}
