% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{en_dia}
\alias{en_dia}
\title{Train an Elastic Net (L1 and L2 Regularized Logistic Regression) Model for Classification}
\usage{
en_dia(X, y, tune = FALSE, cv_folds = 5)
}
\arguments{
\item{X}{A data frame of features.}

\item{y}{A factor vector of class labels.}

\item{tune}{Logical, whether to perform hyperparameter tuning for \code{lambda}
(if \code{TRUE}) or use a fixed value (if \code{FALSE}). \code{alpha} is fixed at 0.5 for Elastic Net.}

\item{cv_folds}{An integer, the number of cross-validation folds for \code{caret}.}
}
\value{
A \code{caret::train} object representing the trained Elastic Net model.
}
\description{
Trains an Elastic Net-regularized logistic regression model
using \code{caret::train} (via \code{glmnet} method) for binary classification.
}
\examples{
\donttest{
set.seed(42)
n_obs <- 50
X_toy <- data.frame(
  FeatureA = rnorm(n_obs),
  FeatureB = runif(n_obs, 0, 100)
)
y_toy <- factor(sample(c("Control", "Case"), n_obs, replace = TRUE),
                levels = c("Control", "Case"))

# Train the model
en_model <- en_dia(X_toy, y_toy)
print(en_model)
}
}
