% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Densities.R
\name{Voss.density}
\alias{LBA.density}
\alias{Voss.density}
\alias{Wiener.density}
\title{Calculate model density for a given set of parameters}
\usage{
Voss.density(t, pars, boundary, DstarM = TRUE, prec = 3)

LBA.density(t, pars, boundary, DstarM = TRUE, ...)

Wiener.density(t, pars, boundary, DstarM)
}
\arguments{
\item{t}{Time grid for density to be calculated on.}

\item{pars}{Parameter vector where (if \code{DstarM == TRUE}) the first index contains the boundary parameter, the second contains the drift speed, the third contains the relative starting point, the fourth contains a proportion of the maximum size of the variance on the relative starting point, the fifth contains the standard deviation of the drift speed.
if \code{DstarM == FALSE} then third index of \code{pars} contains the Ter, the fifth the drift speed, the the sixth contains a proportion of the maximum size of the variance on the relative starting point, the fifth contains the standard deviation of the drift speed, and the seventh contains a proportion of the maximum variance of the Ter.}

\item{boundary}{For which response option will the density be calculated? Either 'upper' or 'lower'.}

\item{DstarM}{Logical, see \code{pars}.}

\item{prec}{Precision with which the density is calculated. Corresponds roughly to the number of decimals accurately calculated.}

\item{...}{Other arguments, see \code{\link{dLBA}}}
}
\value{
A numeric vector of length \code{length(t)} containing a density.
}
\description{
Calculate model density for a given set of parameters
}
\details{
These functions are examples of what \code{fun.density} should look like.
\code{Voss.density} is an adaptation of \code{\link{ddiffusion}},
\code{LBA.density} is an adaptation of \code{\link{dLBA}}, and
\code{wiener.density} is an adaptation of \code{\link{dwiener}}.
To improve speed one can remove error handling.
Normally error handling is useful, however
because differential evolution can result in an incredible number of
function evaluations (more than 10.000) it is recommended to omit error handling in custom
density functions. \code{estDstarM} will apply some internal error checks
(see \code{\link{testFun}}) on the density functions before starting differential
evolution. A version of \code{ddifusion} without error handling can be found in
the source code (commented out to pass R check).
}
\examples{
t = seq(0, .75, .01)
V.pars = c(1, 2, .5, .5, .5)
L.pars = c(1, .5, 2, 1, 1, 1)
W.pars = V.pars[1:3]
V1 = Voss.density(t = t, pars = V.pars, boundary = 'upper', DstarM = TRUE)
V2 = Voss.density(t = t, pars = V.pars, boundary = 'lower', DstarM = TRUE)
L1 = LBA.density(t = t, pars = L.pars, boundary = 'upper', DstarM = TRUE)
L2 = LBA.density(t = t, pars = L.pars, boundary = 'lower', DstarM = TRUE)
W1 = Wiener.density(t = t, pars = W.pars, boundary = 'upper', DstarM = TRUE)
W2 = Wiener.density(t = t, pars = W.pars, boundary = 'lower', DstarM = TRUE)
densities = cbind(V1, V2, L1, L2, W1, W2)
matplot(t, densities, type = 'b', ylab = 'Density', lty = 1, las = 1, bty = 'n',
        col = rep(1:3, each = 2), pch = c(0, 15, 1, 16, 2, 17), cex = .8,
        main = 'Model densities')
legend('topright', legend = c('Voss', 'LBA', 'RWiener'), lty = 1,
       pch = 15:17, col = 1:3, bty = 'n')



}

