% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugRestart.R
\name{addDrugRestart}
\alias{addDrugRestart}
\title{Summarise the drug restart per window.}
\usage{
addDrugRestart(
  cohort,
  switchCohortTable,
  switchCohortId = NULL,
  followUpDays = Inf,
  censorDate = NULL,
  incident = TRUE,
  nameStyle = "drug_restart_{follow_up_days}"
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{switchCohortTable}{A cohort table in the cdm that contains possible
alternative treatments.}

\item{switchCohortId}{The cohort ids to be used from switchCohortTable. If
NULL all cohort definition ids are used.}

\item{followUpDays}{A vector of number of days to follow up. It can be
multiple values.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{incident}{Whether the switch treatment has to be incident (start after
discontinuation) or not (it can start before the discontinuation and last
till after).}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}
}
\value{
A summarised_result object with the percentages of restart, switch
and not exposed per window.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "switch_cohort",
  conceptSet = conceptlist
)

cdm$cohort1 |>
  addDrugRestart(switchCohortTable = "switch_cohort")

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
