% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoMAR.R
\name{autoMAR}
\alias{autoMAR}
\title{Function to identify and generate the Missing at Random features (MAR)}
\usage{
autoMAR(data, aucv = 0.9, strataname = NULL, stratasize = NULL,
  mar_method = "glm")
}
\arguments{
\item{data}{dataframe or data.table}

\item{aucv}{AUC cut-off value for the not missing at random variable selection}

\item{strataname}{vector of stratification variables}

\item{stratasize}{vector of stratum sample sizes (in the order in which the strata are given in the input data set).}

\item{mar_method}{missing at random classification method ("glm", "rf"). Default GLM is used (GLM is run faster for high dimension data)}
}
\value{
List output including missing variable summary and number of MAR flag variables
}
\description{
this function will automatically identify the missing pattern and flag the variable if they are not missing at random based on AUC method
}
\examples{
# Create missing at random features
marobj <- autoMAR (heart, aucv = 0.9, strataname = NULL, stratasize = NULL, mar_method = "glm")
}
