% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{make_layer}
\alias{make_layer}
\title{Creates individual molecular layers from raw data and unique identifiers}
\usage{
make_layer(
  name,
  data_groupA,
  data_groupB,
  identifiers_groupA,
  identifiers_groupB
)
}
\arguments{
\item{name}{[string] Name of the layer.}

\item{data_groupA, data_groupB}{[data.frame] Data frame containing raw molecular data of each group
(each stratum). Analyzed components (e.g. genes) in columns, samples (e.g. patients) in rows.}

\item{identifiers_groupA, identifiers_groupB}{[data.frame] Data frame containing component identifiers
(columns) of each component (rows) in the same order as the molecular data frame of each group.
These identifiers are used to (a) interconnect graphs and (b) match drugs to drug targets.
Must contain a column `type` which identifies the nature of the component (e.g., "protein")}
}
\value{
Named list containing the supplied data for each group (i.e., the data set for one
layer), that can be supplied to \code{\link[DrDimont]{run_pipeline}} and `name` giving the name of the
layer. Each sub-list contains the `data` and the `identifiers`.
}
\description{
Helper function to transform input data to required pipeline input format. Additionally, the
supplied input is checked. Allows easy conversion of raw data into the structure accepted by
\code{\link[DrDimont]{run_pipeline}}.
}
\examples{
data(protein_data)

protein_layer <- make_layer(
                     name="protein",
                     data_groupA=t(protein_data$groupA[, c(-1,-2)]),
                     data_groupB=t(protein_data$groupB[, c(-1,-2)]),
                     identifiers_groupA=data.frame(gene_name=protein_data$groupA$gene_name,
                                                  ref_seq=protein_data$groupA$ref_seq),
                     identifiers_groupB=data.frame(gene_name=protein_data$groupB$gene_name,
                                                  ref_seq=protein_data$groupB$ref_seq))

}
