% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaRESPlot2DCL.R
\name{tVaRESPlot2DCL}
\alias{tVaRESPlot2DCL}
\title{Plots t VaR and ES against confidence level}
\usage{
tVaRESPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there are 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a scalar}
}
\description{
Plots the VaR and ES of a portfolio against confidence level assuming that P/L
data are t distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR and ETL against confidene level given P/L data
   data <- runif(5, min = 0, max = .2)
   tVaRESPlot2DCL(returns = data, df = 7, cl = seq(.85,.99,.01), hp = 60)

   # Computes VaR against confidence level given mean and standard deviation of P/L data
   tVaRESPlot2DCL(mu = .012, sigma = .03, df = 7, cl = seq(.85,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

