% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FrechetES.R
\name{FrechetES}
\alias{FrechetES}
\title{Frechet Expected Shortfall}
\usage{
FrechetES(mu, sigma, tail.index, n, cl, hp)
}
\arguments{
\item{mu}{Location parameter for daily L/P}

\item{sigma}{Scale parameter for daily L/P}

\item{tail.index}{Tail index}

\item{n}{Block size from which maxima are drawn}

\item{cl}{Confidence level}

\item{hp}{Holding period}
}
\value{
Estimated ES. If cl and hp are scalars, it returns scalar VaR. If cl
is vector and hp is a scalar, or viceversa, returns vector of VaRs. If both
cl and hp are vectors, returns a matrix of VaRs.
}
\description{
Estimates the ES of a portfolio  assuming extreme losses
are Frechet distributed, for specified confidence level and a given
holding period.
}
\details{
Note that the long-right-hand tail is fitted to losses, not profits.
}
\examples{
# Computes ES assuming Frechet Distribution for given parameters
   FrechetES(3.5, 2.3, 1.6, 10, .95, 30)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Embrechts, P., Kluppelberg, C. and Mikosch, T., Modelling Extremal Events for
Insurance and Finance. Springer, Berlin, 1997, p. 324.

Reiss, R. D. and Thomas, M. Statistical Analysis of Extreme Values from
Insurance, Finance, Hydrology and Other Fields, Birkhaueser, Basel, 1997,
15-18.
}

