% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{make_pliv_multiway_cluster_CKMS2021}
\alias{make_pliv_multiway_cluster_CKMS2021}
\title{Generates data from a partially linear IV regression model with
multiway cluster sample used in Chiang et al. (2021).}
\usage{
make_pliv_multiway_cluster_CKMS2021(
  N = 25,
  M = 25,
  dim_X = 100,
  theta = 1,
  return_type = "DoubleMLClusterData",
  ...
)
}
\arguments{
\item{N}{(\code{integer(1)}) \cr
The number of observations (first dimension).}

\item{M}{(\code{integer(1)}) \cr
The number of observations (second dimension).}

\item{dim_X}{(\code{integer(1)}) \cr
The number of covariates.}

\item{theta}{(\code{numeric(1)}) \cr
The value of the causal parameter.}

\item{return_type}{(\code{character(1)}) \cr
If \code{"DoubleMLClusterData"}, returns a \code{DoubleMLClusterData} object.
If \code{"data.frame"} returns a \code{data.frame()}.
If \code{"data.table"} returns a \code{data.table()}.
If \code{"matrix"} a named \code{list()} with entries \code{X}, \code{y}, \code{d}, \code{z} and
\code{cluster_vars} is returned.
Every entry in the list is a \code{matrix()} object.  Default is \code{"DoubleMLClusterData"}.}

\item{...}{Additional keyword arguments to set non-default values for the parameters
\eqn{\pi_{10}=1.0},
\eqn{\omega_X = \omega_{\varepsilon} = \omega_V = \omega_v = (0.25, 0.25)},
\eqn{s_X = s_{\varepsilon v} = 0.25}, or the \eqn{p_x}-vectors
\eqn{\zeta_0 = \pi_{20} = \xi_0} with default entries
\eqn{\zeta_{0})_j = 0.5^j}.}
}
\value{
A data object according to the choice of \code{return_type}.
}
\description{
Generates data from a partially linear IV regression model with multiway
cluster sample used in Chiang et al. (2021). The data generating process
is defined as

\eqn{Z_{ij} = X_{ij}' \xi_0 + V_{ij},}

\eqn{D_{ij} = Z_{ij}' \pi_{10} + X_{ij}' \pi_{20} + v_{ij},}

\eqn{Y_{ij} = D_{ij} \theta + X_{ij}' \zeta_0 + \varepsilon_{ij},}

with

\eqn{X_{ij} = (1 - \omega_1^X - \omega_2^X) \alpha_{ij}^X
+ \omega_1^X \alpha_{i}^X + \omega_2^X \alpha_{j}^X,}

\eqn{\varepsilon_{ij} = (1 - \omega_1^\varepsilon - \omega_2^\varepsilon) \alpha_{ij}^\varepsilon
+ \omega_1^\varepsilon \alpha_{i}^\varepsilon + \omega_2^\varepsilon \alpha_{j}^\varepsilon,}

\eqn{v_{ij} = (1 - \omega_1^v - \omega_2^v) \alpha_{ij}^v
+ \omega_1^v \alpha_{i}^v + \omega_2^v \alpha_{j}^v,}

\eqn{V_{ij} = (1 - \omega_1^V - \omega_2^V) \alpha_{ij}^V
+ \omega_1^V \alpha_{i}^V + \omega_2^V \alpha_{j}^V,}

and \eqn{\alpha_{ij}^X, \alpha_{i}^X, \alpha_{j}^X \sim \mathcal{N}(0, \Sigma)}
where \eqn{\Sigma} is a \eqn{p_x \times p_x} matrix with entries
\eqn{\Sigma_{kj} = s_X^{|j-k|}}.

Further

\eqn{\left(\begin{array}{c} \alpha_{ij}^\varepsilon \\ \alpha_{ij}^v \end{array}\right),
\left(\begin{array}{c} \alpha_{i}^\varepsilon \\ \alpha_{i}^v \end{array}\right),
\left(\begin{array}{c} \alpha_{j}^\varepsilon \\ \alpha_{j}^v \end{array}\right)
\sim \mathcal{N}\left(0, \left(\begin{array}{cc} 1 & s_{\varepsilon v} \\
s_{\varepsilon v} & 1 \end{array}\right) \right)}

and \eqn{\alpha_{ij}^V, \alpha_{i}^V, \alpha_{j}^V \sim \mathcal{N}(0, 1)}.
}
\references{
Chiang, H. D., Kato K., Ma, Y. and Sasaki, Y. (2021),
Multiway Cluster Robust Double/Debiased Machine Learning,
Journal of Business & Economic Statistics,
\doi{10.1080/07350015.2021.1895815}, https://arxiv.org/abs/1909.03489.
}
