% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSgof2.R
\name{KSgof2}
\alias{KSgof2}
\title{One-sample Kolmogorov-Smirnov goodness-of-fit test}
\usage{
KSgof2(
  x,
  dist = c("norm", "exp", "unif", "lnorm", "weibull", "gamma", "t", "chisq"),
  ...,
  eps = 1e-15
)
}
\arguments{
\item{x}{Numeric vector of observations.}

\item{dist}{Character string specifying the distribution to test against.
One of \code{"norm"}, \code{"exp"}, \code{"unif"}, \code{"lnorm"}, \code{"weibull"},
\code{"gamma"}, \code{"t"}, or \code{"chisq"}.}

\item{...}{Additional parameters passed to the distribution’s cumulative distribution function (CDF).
For example, \code{mean} and \code{sd} for the normal distribution.}

\item{eps}{Numeric lower and upper bound for tail probabilities to avoid numerical issues (default: \code{1e-15}).}
}
\value{
An object of class \code{"htest"} containing the test statistic, p-value, method description, and data name.
}
\description{
Performs the one-sample Kolmogorov-Smirnov test for a specified theoretical distribution.
}
\details{
The test compares the empirical distribution function of \code{x} with the cumulative distribution function
of a specified theoretical distribution using the Kolmogorov-Smirnov statistic.
For large sample sizes, a p-value approximation based on the asymptotic distribution is used.

A correction is applied when sample size exceeds 100, adjusting the test statistic to approximate a fixed sample size.
For very small or very large statistics, piecewise polynomial approximations are used to compute the p-value.
}
\examples{
set.seed(123)
x <- rnorm(1000, mean = 5, sd = 2)
KSgof2(x, dist = "norm", mean = 5, sd = 2)

y <- rexp(500, rate = 0.5)
KSgof2(y, dist = "exp", rate = 0.5)

u <- runif(300, min = 0, max = 10)
KSgof2(u, dist = "unif", min = 0, max = 10)

}
