% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{nGradientDE}
\alias{nGradientDE}
\title{Negative gradient of log likelihood with respect to all parameters}
\usage{
nGradientDE(theta, Y, X, summed = TRUE)
}
\arguments{
\item{theta}{A vector of parameter values to obtain the gradient at. The
order of parameters is coefficients of equation 1, coefficients of equation 2,
log variance of equation 1, inverse hyperbolic tangent of the correlation of equations 1 and 2,
and log variance of equation 2.}

\item{Y}{A vector of observed responses.}

\item{X}{A list of two elements. The first element is a \eqn{N \times k_1}{N x k[1]}
design matrix for equation 1 and the second element is a \eqn{N \times k_2}{N x k[2]}
design matrix for equation 2.}

\item{summed}{A logical to determine if gradient values are summed over observations.}
}
\value{
A \eqn{(k_1 + k_2 + 3)}{(k[1] + k[2] + 3)} dimension vector of
derivatives if \code{summed = TRUE}, else a
\eqn{N \times (k_1 + k_2 + 3)}{N x (k[1] + k[2] + 3)} matrix of derivatives.
}
\description{
Negative gradient of log likelihood with respect to all parameters
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)

p1 = 2
p2 = 2
theta = c(beta01, beta02, log(SigmaX[1, 1]), atanh(SigmaX[1, 2]), log(SigmaX[2, 2]))

Gradient = nGradientDE(theta, Y, X, summed = TRUE)
head(Gradient)

}
