% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_graph.R
\name{save_graph}
\alias{save_graph}
\title{Save a graph or graph series to disk}
\usage{
save_graph(x, file)
}
\arguments{
\item{x}{A graph object of class \code{dgr_graph} or a graph series object of type
\code{dgr_graph_1D}.}

\item{file}{A file name for the graph or graph series. Provide a character
string and the \code{.dgr} extension will be applied to it.}
}
\description{
Save a graph or a graph series object to disk.
}
\examples{
# Create an undirected GNP
# graph with 100 nodes using
# a probability value of 0.05
gnp_graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnp_graph(
    n = 100,
    p = 0.05)

# Save the graph to disk; use
# the file name `gnp_graph.dgr`
# save_graph(
#   x = gnp_graph,
#   file = "gnp_graph"
# )

# To read the graph file from
# disk, use `open_graph()`
# gnp_graph_2 <-
#   open_graph(
#     file = "gnp_graph.dgr"
# )
}
\seealso{
Other Display and Save: 
\code{\link{export_graph}()},
\code{\link{render_graph_from_graph_series}()},
\code{\link{render_graph}()}
}
\concept{Display and Save}
