% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_nodes_ws.R
\name{add_n_nodes_ws}
\alias{add_n_nodes_ws}
\title{Add a multiple of new nodes with edges to or from
one or more selected nodes}
\usage{
add_n_nodes_ws(graph, n, direction = NULL, type = NULL, label = NULL,
  rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of new nodes to attach as
successor nodes to the nodes in the selection.}

\item{direction}{using \code{from} will create new
edges from existing nodes to the new nodes. The
\code{to} option will create new edges directed
toward the existing nodes.}

\item{type}{an optional character vector that
provides group identifiers for the nodes to be added.}

\item{label}{an optional character object that
describes the nodes to be added.}

\item{rel}{an optional string to apply a
\code{rel} attribute to all newly created edges.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add n new nodes to or from one or more
nodes available as a selection in a graph object of
class \code{dgr_graph}. New graph edges will all
move either from the nodes in the selection toward
the newly created nodes (with the option
\code{direction = "from"}), or to the selected nodes
already in the graph (using \code{direction = "to"}).
Optionally, set node \code{type} and edge \code{rel}
values for all the new nodes and edges created,
respectively.

Selections of nodes can be performed using
the following \code{select_...} functions:
\code{select_nodes()},
\code{select_last_nodes_created()},
\code{select_nodes_by_degree()},
\code{select_nodes_by_id()}, or
\code{select_nodes_in_neighborhood()}.
Selections of nodes can also be performed using
the following traversal functions:
(\code{trav_...}):
\code{trav_out()}, \code{trav_in()},
\code{trav_both()}, \code{trav_in_node()},
\code{trav_out_node()}.
}
\examples{
# Create an empty graph, add a node to it, select
# that node, and then add 5 more nodes to the graph
# with edges from the original node to all of the
# new nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 1) \%>\%
  select_last_nodes_created() \%>\%
  add_n_nodes_ws(
    n = 5,
    direction = "from")

# Get the graph's nodes
get_node_ids(graph)
#> [1] 1 2 3 4 5 6

# Get the graph's edges
graph \%>\%
  get_edges()
#> "1->2" "1->3" "1->4" "1->5" "1->6"

# Create an empty graph, add a node to it, select
# that node, and then add 5 more nodes to the graph
# with edges toward the original node from all of
# the new nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 1) \%>\%
  select_last_nodes_created() \%>\%
  add_n_nodes_ws(
    n = 5,
    direction = "to")

# Get the graph's nodes
get_node_ids(graph)
#> [1] 1 2 3 4 5 6

# Get the graph's edges
get_edges(graph)
#> "2->1" "3->1" "4->1" "5->1" "6->1"
}
